﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Xna.Framework;
using System.IO;
using Microsoft.Xna.Framework.Graphics;

namespace CashierCrisis.Entities
{
    public class Entity
    {
        private static int _idIndex = 0;
        private int _id;
        public int ID
        {
            get { return _id; }
        }

        private List<Component> _components = new List<Component>();
        private Dictionary<string, Component> _componentDictionary = new Dictionary<string, Component>();

        private EntityPool _pool = null;
        public EntityPool Pool
        {
            get { return _pool; }
            set { _pool = value; }
        }

        public Vector2 Position = Vector2.Zero;

        public Entity()
        {
            _idIndex++;
            _id = _idIndex;
        }

        public Entity(Entity entity)
            : this()
        {

            _components = new List<Component>(entity._components.Count);
            for (int i=0; i < entity._components.Count; i++)
            {
                _components[i].CopyTo(entity._components[i]);
          
            }

        }

        public void Update(GameTime gameTime)
        {
            for (int i = 0; i < _components.Count; i++)
            {
                _components[i].Update(gameTime);
            }
        }

        public void Draw(SpriteBatch spriteBatch)
        {
            for (int i = 0; i < _components.Count; i++)
            {
                _components[i].Draw(spriteBatch);
            }
        }

        public void Recycle()
        {
            if (_pool != null)
            {
                Pool.Return(this);
            }
        }

        public void AddComponent(Component component)
        {
            if (component == null)
            {
                return;
            }

            component.Entity = this;
            _components.Add(component);
            _componentDictionary.Add(component.Name, component);
        }

        public Component GetComponent(string name)
        {
            return _componentDictionary[name];
        }

        public void RemoveComponents()
        {
            _components.Clear();
            _componentDictionary.Clear();
        }

        public void Copy(Entity entity)
        {
            _components = new List<Component>(entity._components.Count);
            for (int i = 0; i < entity._components.Count; i++)
            {
                _components[i].CopyTo(entity._components[i]);
            }

        }







   
    }
}
